/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.gui.actions.shells.construct;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import net.nooj4nlp.controller.ConcordanceShell.ConcordanceShellController;
import net.nooj4nlp.controller.TextEditorShell.TextEditorShellController;
import net.nooj4nlp.gui.main.Launcher;
import net.nooj4nlp.gui.shells.ConcordanceShell;
import net.nooj4nlp.gui.shells.TextEditorShell;

public class OpenConcordanceActionListener
implements ActionListener {
    private JDesktopPane desktopPane;

    public OpenConcordanceActionListener(JDesktopPane dp) {
        this.desktopPane = dp;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JInternalFrame selectedFrame = this.desktopPane.getSelectedFrame();
        if (selectedFrame == null) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Please select a text or a corpus for the concordance", "NooJ: needs a text/corpus to link a concordance to", 0);
            return;
        }
        ConcordanceShell concordanceShell = null;
        String cls = selectedFrame.getClass().getSimpleName();
        if (cls.equals("TextEditorShell")) {
            if (Launcher.getOpenConcordanceChooser().showOpenDialog(null) != 0) {
                return;
            }
            if (cls.equals("TextEditorShell")) {
                TextEditorShell textEditorShell = (TextEditorShell)selectedFrame;
                TextEditorShellController textController = textEditorShell.getTextController();
                concordanceShell = new ConcordanceShell(textController);
                ConcordanceShellController concordanceController = new ConcordanceShellController(concordanceShell);
                textController.setConcordanceController(concordanceController);
                concordanceController.loadConcordance(Launcher.getOpenConcordanceChooser().getSelectedFile().getAbsolutePath());
            }
        } else {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Please Select a text or a corpus", "NooJ cannot link concordance to text nor corpus", 0);
            return;
        }
    }
}

